<?php

namespace App\Livewire\Admin\Settings\System;

use Livewire\Component;
use App\Models\User;
use App\Models\Contact;
use App\Models\Campaign;
use App\Models\ChatMessage;

class SystemUpdateSettings extends Component
{
    public $currentVersion;
    public $totalContacts;
    public $totalCampaigns;
    public $totalMessages;
    public $totalUsers;
    public $systemUptime;
    public $appName;
    public $buildVersion;
    public $lastUpdate;
    public $verificationId;
    public $verificationToken;
    public $lastVerification;
    public $supportUntil;
    public $verificationStatus;

    public function mount()
    {
        if (! checkPermission('system_settings.view')) {
            $this->notify(['type' => 'danger', 'message' => t('access_denied_note')], true);

            return redirect(route('admin.dashboard'));
        }

        // Version and App Info
        $this->currentVersion = get_setting('whats-mark.wm_version', '1.0.4');
        $this->appName = get_setting('whats-mark.wm_app_name', 'WhatsMark Pro');
        $this->buildVersion = 'Build ' . date('Y.m.d') . '.1';
        $this->lastUpdate = get_setting('whats-mark.wm_last_update', now()->subDays(5)->format('Y-m-d'));

        // Database Statistics
        $this->totalContacts = Contact::count();
        $this->totalCampaigns = Campaign::count();
        $this->totalMessages = ChatMessage::count();
        $this->totalUsers = User::count();

        // WhatsApp Verification Settings
        $this->verificationId = get_setting('whats-mark.wm_verification_id', '');
        $this->verificationToken = get_setting('whats-mark.wm_verification_token', '');
        $this->lastVerification = get_setting('whats-mark.wm_last_verification', '');
        $this->supportUntil = get_setting('whats-mark.wm_support_until', '');

        // Format verification timestamp
        if (!empty($this->lastVerification) && is_numeric($this->lastVerification)) {
            $this->lastVerification = date('Y-m-d H:i:s', (int)$this->lastVerification);
        } else {
            $this->lastVerification = 'Never';
        }

        // Set verification status
        if (!empty($this->verificationId) && !empty($this->verificationToken)) {
            $this->verificationStatus = 'Verified';
        } else {
            $this->verificationStatus = 'Not Verified';
        }

        // Calculate System Uptime
        $firstRecord = ChatMessage::oldest('created_at')->first();
        if ($firstRecord) {
            $daysSinceFirstRecord = now()->diffInDays($firstRecord->created_at);
            $this->systemUptime = $daysSinceFirstRecord . ' days';
        } else {
            $firstUser = User::oldest('created_at')->first();
            if ($firstUser) {
                $daysSinceFirstUser = now()->diffInDays($firstUser->created_at);
                $this->systemUptime = $daysSinceFirstUser . ' days';
            } else {
                $this->systemUptime = '1 day';
            }
        }
    }

    public function render()
    {
        return view('livewire.admin.settings.system.system-update-settings');
    }
}
