<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Message bots
        Schema::create('message_bots', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->longText('description')->nullable();
            $table->json('triggers')->nullable(); // keywords that trigger bot
            $table->json('responses')->nullable(); // bot responses
            $table->boolean('is_active')->default(1);
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
        });

        // Template bots
        Schema::create('template_bots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('message_bot_id')->constrained()->onDelete('cascade');
            $table->string('template_type'); // welcome, fallback, etc.
            $table->longText('template_content');
            $table->json('variables')->nullable();
            $table->timestamps();
        });

        // Webhook logs
        Schema::create('webhook_logs', function (Blueprint $table) {
            $table->id();
            $table->string('url');
            $table->string('method');
            $table->json('headers')->nullable();
            $table->longText('payload');
            $table->longText('response')->nullable();
            $table->integer('status_code')->nullable();
            $table->integer('response_time')->nullable(); // in milliseconds
            $table->enum('status', ['pending', 'success', 'failed'])->default('pending');
            $table->text('error_message')->nullable();
            $table->timestamps();
        });

        // WM activity logs
        Schema::create('wm_activity_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('action'); // login, logout, create_contact, etc.
            $table->string('description');
            $table->json('data')->nullable(); // additional data
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wm_activity_logs');
        Schema::dropIfExists('webhook_logs');
        Schema::dropIfExists('template_bots');
        Schema::dropIfExists('message_bots');
    }
};